package ptft;

/*
 * NamedColorArray.java
 *
 * Created on May 15, 2004, 1:48 PM
 */

import java.awt.Color;

/**
 *
 * @author  Will Braynen
 */
public final class NamedColorArray {
    
    protected NamedColor[] m_namedColorArray;
    protected int m_currentIndex = 0;
    
    /** Creates a new instance of dtft */
    public NamedColorArray(int arraySize) {

        m_namedColorArray = new NamedColor[ arraySize ];
    }
    
    public void addColor( Color color, String name ) {
        
        if (m_currentIndex > m_namedColorArray.length)
        {
            return; // throw exception instead!
            
            // you might also want to enforce non-duplicate colors
        }
        
        m_namedColorArray[ m_currentIndex ] = new NamedColor( color, name );
        m_currentIndex++;
    }

    public void addNamedColor( NamedColor aNamedColor ) {
        
        if (m_currentIndex > m_namedColorArray.length)
        {
            return; // throw exception instead!
            
            // you might also want to enforce non-duplicate colors
        }
        
		m_namedColorArray[ m_currentIndex ] = aNamedColor;
        m_currentIndex++;
    }

	
	public int getLength() {
        
        return m_namedColorArray.length;
    }
    
    public Color getColor( int index ) {
        
        return m_namedColorArray[index].getColor();
    }
    
    public String getName( int index ) {
        
        return m_namedColorArray[index].getName();
    }
	
	public String getNameWithPayoffs( int index ) {
		
		return m_namedColorArray[index].getNameWithPayoffs();
	}
    
    public String[] getNames() {
        
        String[] nameArray = new String[m_namedColorArray.length];
        for (int i = 0;  i < m_namedColorArray.length;  i++) {
            nameArray[i] = m_namedColorArray[i].getName();
        }
        return nameArray;
    }

    public String[] getNamesWithPayoffs() {
        
        String[] nameArray = new String[m_namedColorArray.length];
        for (int i = 0;  i < m_namedColorArray.length;  i++) {
			String title = m_namedColorArray[i].getNameWithPayoffs();
			System.out.println("title: " + title);
            nameArray[i] = title;
        }
        return nameArray;
    }
	
    public Color[] getColors() {
        
        Color[] colorArray = new Color[m_namedColorArray.length];
        for (int i = 0;  i < m_namedColorArray.length;  i++) {
            colorArray[i] = m_namedColorArray[i].getColor();
        }
        return colorArray;
    }
	
	public NamedColor getNamedColor(int index) {
		return m_namedColorArray[index];
	}
}
