package ptft;

/*
 * NamedColor.java
 *
 * Created on May 16, 2004, 10:19 AM
 */

import java.awt.Color;


/**
 *
 * @author  Will Braynen
 */
public final class NamedColor {
    
    private Color m_color;
    private String m_name;
	private int m_minPayoff = 100;
	private int m_maxPayoff = 100;
	
    /** Creates a new instance of NamedColor */
    public NamedColor( Color color, String name ) {
        
        m_color = color;
        m_name = new String (name);

	}
    
    public Color getColor() {
        return m_color;
    }
    
    public String getName() {
        return m_name;
    }
	
	public void setColor( Color color ) {
        m_color = color;
    }
    
    public void setName( String name ) {
        m_name = new String (name);
    }
	
	public void setMinPayoff( int payoff ) {
		m_minPayoff = payoff;
	}
	
	public int getMinPayoff() {
		return m_minPayoff;
	}
	
	public void setMaxPayoff( int payoff ) {
		m_maxPayoff = payoff;
	}
	
	public int getMaxPayoff() {
		return m_maxPayoff;
	}
	
	public String getNameWithPayoffs() {
		return m_name + " (" + m_minPayoff + "-" + m_maxPayoff + "%)";
	}
}
