package ptft;

/*
 * JPtftLabel.java
 *
 * Created on May 15, 2004, 10:52 AM
 */

import java.awt.*;

/**
 *
 * @author  Will Braynen
 */
public class JLegendLabel extends javax.swing.JLabel {
    
    
    // fields
    protected Color m_fillColor;
    protected Color m_outlineColor;
    
    
    /** Creates new form JPtftLabel */
    public JLegendLabel() {
        this (Color.white); // default fillColor
    }
    
    public JLegendLabel(Color fillColor) {
        this (fillColor, Color.black); // default outlineColor
    }
    
    public JLegendLabel(Color fillColor, Color outlineColor) {
        m_fillColor = fillColor;
        m_outlineColor = outlineColor;
        initComponents();
    }
    
    public Color getFillColor() {
        return m_fillColor;
    }
    
    public void setFillColor( Color color ) {
        m_fillColor = color;
    }
    
    public Color getOutlineColor() {
        return m_outlineColor;
    }
    
    public void setOutlineColor( Color color ) {
        m_outlineColor = color;
    }
    
    public void paintComponent( Graphics g ) {

        super.paintComponent( g );

        final int offset = 5;
        final int cellWidth = 5;

        // draw the outline
        g.setColor( m_outlineColor );
        g.drawRect( offset, offset, cellWidth + 1, cellWidth + 1 );

        // draw the box
        g.setColor( m_fillColor );
        g.fillRect( offset + 1, offset + 1, cellWidth, cellWidth );

    } // end paintComponent
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
