package ptft;

/*
 * JGridButton.java
 *
 * Created on May 22, 2004, 6:29 PM
 */

import java.awt.Color;
import java.awt.Graphics;

/**
 *
 * @author  Will Braynen
 */
public final class JGridButton extends javax.swing.JButton {
    
    Color m_gridColorNW = Color.white;
    Color m_gridColorNE = Color.white;
    Color m_gridColorSW = Color.white;
    Color m_gridColorSE = Color.white;
    
    /** Creates new form JGridButton */
    public JGridButton() {
        initComponents();
    }
    
    public void setGridColor( Color c ) {

        m_gridColorNW = m_gridColorNE = m_gridColorSW = m_gridColorSE = c;
    }
    
    public void setGridColor1( Color c ) {
        m_gridColorNW = c;
    }
    
    public void setGridColor2( Color c ) {
        m_gridColorNE = c;
    }
    
    public void setGridColor3( Color c ) {
        m_gridColorSW = c;
    }

    public void setGridColor4( Color c ) {
        m_gridColorSE = c;
    }
    
    public void paint( Graphics g ) {
        
        super.paint( g );
        
        // draw a colored grid.
        
        // NW
        g.setColor( m_gridColorNW );
        g.fillRect(  7,  8, 5, 5 );
        
        // NE
        g.setColor( m_gridColorNE );
        g.fillRect( 13,  8, 5, 5 );
        
        // SW
        g.setColor( m_gridColorSW );
        g.fillRect(  7, 14, 5, 5 );
        
        // SE
        g.setColor( m_gridColorSE );
        g.fillRect( 13, 14, 5, 5 );
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        
        setLayout(new java.awt.BorderLayout());
        
    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
