package ptft;

/*
 * JGrid.java
 *
 * Created on May 11, 2004, 3:28 PM
 */

import java.awt.*;

/**
 * A graph paper grid populated with <code>JCell</code> objects.
 * 
 * @author  Will Braynen
 */
public class JGrid extends javax.swing.JPanel {
    
    protected int m_columns;
    protected int m_rows;
    protected int m_cellWidth = 5;
    protected int m_cellPadding = 1;
    protected JCell m_grid[][];
    public NamedColorArray m_strategies;
	protected int generation = 0;
    
    /** Creates new form JGrid */
    public JGrid(int cellWidth) {
        this(64,64,cellWidth);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        innerPanel = new javax.swing.JPanel();

        setLayout(null);

        setPreferredSize(new java.awt.Dimension(385, 385));
        innerPanel.setPreferredSize(new java.awt.Dimension(383, 383));
        add(innerPanel);
        innerPanel.setBounds(1, 1, 383, 383);

    }//GEN-END:initComponents
    
  
    /** Creates new form JGrid */
    public JGrid( int rows, int columns, int cellWidth ) {
        
        super();
        
        m_cellWidth = cellWidth;
        
        initComponents();

        m_cellWidth = cellWidth;

        // set the layout
        GridLayout gridLayout = new GridLayout( rows, columns, m_cellPadding, m_cellPadding );
        innerPanel.setLayout (gridLayout);
        
        setBorderColor (Color.black); 
        setGridColor (Color.black);
        
        int width  = m_cellPadding + columns * (m_cellWidth + m_cellPadding);
        int height = m_cellPadding + rows * (m_cellWidth + m_cellPadding);
        setPreferredSize (new Dimension (width, height));
        innerPanel.setPreferredSize(new Dimension(width-2,height-2));
        innerPanel.setBounds(1,1,width-2,height-2);

        // set fields
        m_rows = rows;
        m_columns = columns;
        m_grid = new JCell[m_rows][m_columns];

    } // end constructor

    public void setBackground( Color color ) {
        
        setBorderColor( color );
        setGridColor( color );
    }
    
    public void setBorderColor (Color color) {
        
        super.setBackground( color );
    }
    
    public void setGridColor( Color color ) {
        
        if (null != innerPanel)
            innerPanel.setBackground( color );
    }
    
    /** Captures attempts to change the layout manager and ignores them */
    public void setLayout( LayoutManager mng ) {
        
        // Do nothing.  We like the one we have just fine.
    }
    
    /** add cells to GUI */
    public void createCells( NamedColorArray strategies  )
    {
        m_strategies = strategies;
        
        // create cells and add them to GUI
        for (int x = 0;  x < m_rows;  x++)
        {
            for (int y = 0;  y < m_columns;  y++)
            {
                JCell cell = new JCell(x, y, m_cellWidth, strategies);
                m_grid[x][y] = cell;
                
                // add the cell to the GUI
                innerPanel.add (cell);
            }
        }
    } // end initCells
        
    public void paintComponent( Graphics g ) 
    {
        g.setColor (getBackground());
        g.fillRect (0, 0, getSize().width, getSize().height);
    }
    
    public int getTotalRows()
    {
        return m_rows;
    }

    public int getTotalColumns()
    {
        return m_columns;
    }
 
    public void setRandomStrategies() {
        
        setRandomStrategies( null );
    }
    
    public void setRandomStrategies( int[] strategies ) {
        
        for (int x = 0;  x < m_rows;  x++)
            for (int y = 0;  y < m_columns; y++)
                m_grid[x][y].setRandomStrategy( strategies );
    }
    
    public JCell getCell( int x, int y ) throws IndexOutOfBoundsException
    {
        if (x >= m_rows || y >= m_columns ||
            x < 0 || y < 0) throw new IndexOutOfBoundsException();
        return m_grid[x][y];
    }
    
    /**
     * wrap-around grid: cells in the bottom row neighbor those in the top row,
     * and cells in the right column neighbor those in the left column.
     */
    public JCell getNeighbor( JCell cell, Direction d ) {
        
        return getNeighbor( cell.getRow(), cell.getColumn(), d );        
    }
    
    private JCell getNeighbor( int row, int column, Direction d ) throws IndexOutOfBoundsException {
        
        if (row >= m_rows || column >= m_columns ||
            row < 0 || column < 0) throw new IndexOutOfBoundsException();

        else if (Direction.W  == d) { column = getLeftColumn( column );  }
        else if (Direction.E  == d) { column = getRightColumn( column ); }
        else if (Direction.N  == d) { row = getUpperRow( row );    }
        else if (Direction.S  == d) { row = getLowerRow( row );    }
        else if (Direction.NW == d) 
        {
            row = getUpperRow( row );
            column = getLeftColumn( column );
        }
        else if (Direction.NE == d)
        {
            row = getUpperRow( row );
            column = getRightColumn( column );
        }
        else if (Direction.SW == d)
        {
            row = getLowerRow( row );
            column = getLeftColumn( column );
        }
        else if (Direction.SE == d)
        {
            row = getLowerRow( row );
            column = getRightColumn( column );
        }
        
        return m_grid[ row ][ column ];
    }
    
    protected int getRightColumn( int column ) {

        if (++column >= this.m_columns) column = 0;
        return column;
    }
    
    protected int getLeftColumn( int column ) {
        
        if (--column < 0) column = this.m_columns - 1;
        return column;
    }
    
    protected int getUpperRow( int row ) {
        
        if (++row >= this.m_rows) row = 0;
        return row;
    }
    
    protected int getLowerRow( int row ) {
        
        if (--row < 0) row = this.m_rows - 1;
        return row;
    }
	
	protected int getGeneration() {
		return generation;
	}
	
	protected void setGeneration( int p_generation ) {
		this.generation = p_generation;
	}
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JPanel innerPanel;
    // End of variables declaration//GEN-END:variables
    
}
