package ptft;

/*
 * JCell.java
 *
 * Created on May 10, 2004, 5:38 PM
 */

import java.awt.*;

/**
 * A square cell whose color corresponds to a strategy field.
 *
 * @author  Will Braynen
 */
public class JCell extends javax.swing.JComponent {
   
    // fields
    protected int m_width = 8; // pixel width and height (each cell is a square)
    protected int m_row; // grid location
    protected int m_column; // grid location
    protected int m_strategy;
    protected int m_newStrategy;
    protected NamedColorArray m_strategyColors;
    public int m_score;
	public int payoff_max = 100; //percent of the payoff that the cell can receive
	public int payoff_min = 60; //minimum payoff percentage possible
       
    /** Creates a new cell with a random strategy. */
    public JCell( int row, int column, int cellWidth, NamedColorArray strategyColors ) 
    {
        // init the fields
        m_row    = row;
        m_column = column;
        m_strategyColors = strategyColors;
        m_width = cellWidth;
        setRandomStrategy();
        setPreferredSize (new Dimension (m_width, m_width));
        
    } // end constructor
    
    public void setRandomStrategy() {
        
        setRandomStrategy( null );
    }
    
    protected int getRandomNumber( int[] numbers ) {

        int i = (int)(Math.random() * numbers.length);
        return numbers[ i ];           
    }
    
    public int getRow() {
        
        return m_row;
    }
    
    public int getColumn() {
        
        return m_column;
    }
    
    /**
     * Pre-condition: any strategies[i] must be less than the total number of 
     *                strategies.
     *                
     * @param  strategies  the array of strategies for the random pool;
     *                     for example, if m_strategyColors has six colors
     *                     but you want to randomly pick only between 
     *                     strategies 3 and 5, then strategies = { 3, 5 }.
     *                     <p>
     *                     If strategies is null or is empty, then picks
     *                     from the entire range of strategies.
     */
    public void setRandomStrategy( int[] strategies ) {

        if (null == strategies  ||  0 == strategies.length) {
            // pick from entire pool
            m_strategy = (int)(Math.random() * m_strategyColors.getLength());
        }
        else {
            m_strategy = getRandomNumber( strategies );
        }
        
    } // end setRandomColor
    
    public void paintComponent( Graphics g ) {
        g.setColor (m_strategyColors.getColor( m_strategy ));
        g.fillRect (0, 0, m_width, m_width);
    } // end paintComponent
        
    public int getStrategy() {
        return m_strategy;
    } // end getStrategy
    
    public void setStrategy( int strategy ) {
        m_strategy = strategy;
    }
	
	public int getMaxPayoffPercent() {
		return payoff_max;
	}
	
	public void setMaxPayoffPercent( int percent ) {
		if ( percent >= 0 && percent <= 100 ) {
			this.payoff_max = percent;
		}
	}
	
	public int getMinPayoffPercent() {
		return this.payoff_min;
	}
	
	public void setMinPayoffPercent( int percent ) {
		if ( percent >= 0 && percent <= 100 ) {
			this.payoff_min = percent;
		}
	}
	
	
	public int getRandomPayoffPercentage() {
		
		int retval = this.payoff_min;
	
		if ( this.payoff_max > this.payoff_min ) {
			//randomly pick a value between the min and max payoff of this cell
			retval += (int)(Math.random()*(this.payoff_max - payoff_min + 1));
		}
		
		return retval;
		
	}
	
} // end class JCell
