package ptft;

/*
 * Toolkit.java
 *
 * Created on May 16, 2004, 6:32 PM
 */

import javax.swing.ImageIcon;
import java.awt.*;
import java.net.URL;

/**
 *
 * @author  Will Braynen
 */
public final class ImageToolkit {
    
    /** Creates a new instance of Toolkit */
    private ImageToolkit() {
    }

    /** 
     * @param  c  if calling from a component, pass in <code>this</code>
     * @param  filename  server-side relative path 
     */
    public static ImageIcon createImageIcon( Component c, String filename ) {
        
        URL url = c.getClass().getResource( filename );
        return new ImageIcon( url );
    }
    
    /** 
     * @param  c  if calling from a component, pass in <code>this</code>
     * @param  filename  server-side relative path
     * @param  hotSpot   the X and Y of the large cursor's hot spot; 
     *                   the hotSpot values must be less than the Dimension 
     *                   returned by <code>getBestCursorSize</code>
     * @param  name      a localized description of the cursor, 
     *                   for Java Accessibility use
     */
    public static Cursor createCursor( Component c, String filename, Point hotSpot, String name ) {
        
        Cursor cursor = null;
        
        // Query for custom cursor support
        Toolkit tk = c.getToolkit();
        Dimension d = tk.getBestCursorSize(32, 32);
        int colors = tk.getMaximumCursorColors();
        if ( ! d.equals(new Dimension(0, 0) )  &&  (colors != 0) ) 
        { 
            // If getBestCursorSize returns a non-zero size and
            // getmaximumCursorColors returns a non-zero value,
            // then platform supports custom cursors
            
            // You can now load the appropriate image file (GIF or JPEG)
            // for the supported cursor size and number of colors
            // Most platforms will support 32x32, 2-color cursors
            // We assume here that Cursor_X_32_32.gif is a 32x32 2-color
            // gif file. For transparency, use 89a-format gifs.
            URL url = c.getClass().getResource( filename );
            Image image = c.getToolkit().createImage( url );

            if (image != null) { 
                try { 
                    // Create a custom cursor from the image
                    // Specify hot spot coordinates and a string
                    // containing a description of the cursor
                    // for use with Java Accessibility
                    cursor = c.getToolkit().createCustomCursor( image, hotSpot, name );
                } 
                catch(Exception exc) { 
                    // Catch exceptions so that we
                    // don't try to set a null cursor
                    System.err.println("Unable to create custom cursor.");
                    return null;
                }
            } // end if successfully fetched the image from file
        } // end if custom cursors supported
        return cursor;
    } // end createCursor
    
} // end class ImageToolkit
