package ptft;


/**
 * This final class with a private constructor is used 
 * instead of final statics to provide type safety.
 * (In C this would be done with an enum typedef.)
 *
 * @author  Will Braynen
 */

public final class Direction { // class is final, so it can't be subclassed
    
    private Direction () {} // private constructor!
    
    /** North */  public static final Direction N = new Direction();
    /** South */  public static final Direction S = new Direction();
    /** West */   public static final Direction W = new Direction();
    /** East */   public static final Direction E = new Direction();
    /** North-West */   public static final Direction NW = new Direction();
    /** North-East */   public static final Direction NE = new Direction();
    /** South-West */   public static final Direction SW = new Direction();
    /** South-East */   public static final Direction SE = new Direction();
    
    /** 
     * Enumerates directions.  To enumerate all directions, pass any
     * direction in and keep on calling this method until you get back
     * to where you started from.
     *
     * @param  d  a place to start
     * @return  directions going around in a circle in the following order:<br>
     *          NW, N, NE, E, SE, S, SW, W, NW
     */
    public static Direction next( Direction d ) {
        
        if (NW == d) return N;
        else if (N == d) return NE;
        else if (NE == d) return E;
        else if (E == d) return SE;
        else if (SE == d) return S;
        else if (S == d) return SW;
        else if (SW == d) return W;
        else if (W == d) return NW;
        else return null; // unhandled direction
    }
}
